{-|
Module      : Test.Core.Worker
Description :
Copyright   : (c) CNRS, 2024-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

module Test.Core.Worker where

import Data.Aeson qualified as Aeson
import Gargantext.Core.Methods.Similarities.Conditional
import Gargantext.Core.Worker.Jobs.Types (Job(..))
import Gargantext.Core.Worker.Types (JobInfo(..))
import Gargantext.Prelude
import Test.Instances ()
import Test.Tasty
import Test.Tasty.HUnit
import Test.Tasty.QuickCheck hiding (Positive, Negative)



tests :: TestTree
tests = testGroup "worker unit tests" [
    testProperty "Worker Job to/from JSON serialization is correct" $
      \job -> Aeson.decode (Aeson.encode (job :: Job)) == Just job

  -- , testProperty "JobInfo to/from JSON serialization is correct" $
  --     \ji -> Aeson.decode (Aeson.encode (ji :: JobInfo)) == Just ji
  ]
