module Test.Utils.Db where

import Data.Maybe (fromJust)
import Database.PostgreSQL.Simple qualified as PSQL
import Database.PostgreSQL.Simple.Options qualified as PSOpts
import Database.Postgres.Temp qualified as Tmp
import Gargantext.Prelude


tmpDBToConnInfo :: Tmp.DB -> PSQL.ConnectInfo
tmpDBToConnInfo db =
  PSQL.ConnectInfo { connectHost = fromJust $ getLast $ PSOpts.host opts
                   , connectPort = fromIntegral $ fromJust $ getLast $ PSOpts.port opts
                   , connectUser = fromJust $ getLast $ PSOpts.user opts
                   , connectPassword = fromJust $ getLast $ PSOpts.password opts
                   , connectDatabase = fromJust $ getLast $ PSOpts.dbname opts }
  where
    opts = Tmp.toConnectionOptions db
