{-|
Module      : Gargantext.API.Routes.Named.List
Description :
Copyright   : (c) CNRS, 2017
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX
-}

{-# LANGUAGE TypeOperators #-}

module Gargantext.API.Routes.Named.List (
  -- * Routes types
    GETAPI(..)
  , ListEndpoints(..)
  , JSONAPI(..)
  , TSVAPI(..)
  ) where

import Data.Text (Text)
import GHC.Generics (Generic)
import Gargantext.API.Ngrams.List.Types (WithJsonFile, WithTextFile)
import Gargantext.API.Ngrams.Types (NgramsList, NgramsListZIP, NgramsTableMap)
import Gargantext.API.Types (HTML)
import Gargantext.API.Worker (WorkerAPI)
import Gargantext.Database.Admin.Types.Node (ListId)
import Gargantext.Utils.Servant qualified as GUS
import Servant

newtype GETAPI mode = GETAPI
  { getListEp :: mode :- Summary "Get List"
                      :> "lists"
                      :> Capture "listId" ListId
                      :> NamedRoutes ListEndpoints
  } deriving Generic

data ListEndpoints mode = ListEndpoints
  { listJSONEp :: mode :- "json"
                       :> Get '[JSON, HTML] (Headers '[Header "Content-Disposition" Text] NgramsList)
  , listJSONZipEp :: mode :- "json.zip"
                          :> Get '[GUS.ZIP] (Headers '[Header "Content-Disposition" Text] NgramsListZIP)
  , listTSVEp :: mode :- "tsv" :> Get '[GUS.TSV] (Headers '[Header "Content-Disposition" Text] NgramsTableMap)
  } deriving Generic

newtype JSONAPI mode = JSONAPI
  { updateListJSONEp :: mode :- Summary "Update List"
                             :> "lists"
                             :> Capture "listId" ListId
                             :> "add"
                             :> "form"
                             :> "async"
                             :> NamedRoutes (WorkerAPI '[FormUrlEncoded] WithJsonFile)
  } deriving Generic


newtype TSVAPI mode = TSVAPI
  { updateListTSVEp :: mode :- Summary "Update List (legacy v3 TSV)"
                            :> "lists"
                            :> Capture "listId" ListId
                            :> "tsv"
                            :> "add"
                            :> "form"
                            :> "async"
                            :> NamedRoutes (WorkerAPI '[FormUrlEncoded] WithTextFile)
  } deriving Generic
