{-# LANGUAGE DataKinds #-}
{-# LANGUAGE TypeOperators #-}
{-# LANGUAGE OverloadedStrings #-}
{-# LANGUAGE ScopedTypeVariables #-}

{-# OPTIONS_GHC -fno-warn-orphans #-}

module Gargantext.API.Image where

import Data.Swagger
import GHC.Generics (Generic)
import Servant
import Servant.Multipart
import Gargantext.API.Prelude
import Gargantext.Prelude
import Gargantext.Database.Admin.Types.Node
import qualified Data.ByteString.Lazy as LBS
import Gargantext.Core.Types (TODO)
import Gargantext.Database.Action.Flow.Types (FlowCmdM)
import qualified Gargantext.Database.GargDB as GargDB
import Gargantext.API.Admin.Types (HasSettings)
import Data.Maybe (fromMaybe)
import Gargantext.Database.Query.Table.User (getUsersWithNodeHyperdata, UserLight (UserLight))
import qualified Data.Text as T
import Gargantext.API.GraphQL.UserInfo (ui_cwImagePathL)
import Gargantext.Database.Schema.Node (node_id, node_hyperdata)
import Gargantext.Database.Query.Table.Node.UpdateOpaleye (updateHyperdata)
import Control.Lens
import Data.Aeson (FromJSON, ToJSON)
import Servant.Ekg
import Servant.Swagger.Internal
import Data.Monoid (mempty)

type ImageUploadAPI = Summary "Image upload endpoint" 
                      :> "image" 
                      :> MultipartForm Mem (MultipartData Mem) :> Post '[JSON] IntResponse

imageUploadAPI :: UserId -> GargServer ImageUploadAPI
imageUploadAPI = upload

instance HasEndpoint sub => HasEndpoint (MultipartForm backend a :> sub) where
  getEndpoint _ = getEndpoint (Proxy :: Proxy sub)
  enumerateEndpoints _ = enumerateEndpoints (Proxy :: Proxy sub)

instance ToParamSchema (MultipartData Mem)
  where toParamSchema _ = toParamSchema (Proxy :: Proxy TODO)

instance (ToParamSchema a, HasSwagger sub) =>
         HasSwagger (MultipartForm tag a :> sub) where
  -- TODO
  toSwagger _ = toSwagger (Proxy :: Proxy sub)
              & addParam param
    where
      param = mempty
            & required ?~ True
            & schema   .~ ParamOther sch
      sch = mempty
          & in_         .~ ParamFormData
          & paramSchema .~ toParamSchema (Proxy :: Proxy a)

newtype IntResponse = IntResponse Int
  deriving (Generic)

instance FromJSON IntResponse
instance ToJSON IntResponse
instance ToSchema IntResponse where
   declareNamedSchema _ = declareNamedSchema (Proxy :: Proxy TODO)

newtype LBSContent = LBSContent LBS.ByteString

instance GargDB.SaveFile LBSContent where
  saveFile' fp (LBSContent a) = do
    LBS.writeFile fp a

upload :: (HasSettings env, FlowCmdM env err m) => UserId -> MultipartData Mem -> m IntResponse
upload uId multipartData = do
  let content = LBSContent $ fromMaybe "" $ head $ map fdPayload (files multipartData)
  fpath <- GargDB.writeFile content
  users <- getUsersWithNodeHyperdata uId
  _ <- case users of
    [] -> panic $ "[updateUserInfo] User with id " <> (T.pack $ show uId) <> " doesn't exist."
    ((UserLight { }, node_u):_) -> do
      let u_hyperdata = node_u ^. node_hyperdata
      let u_hyperdata' = u_hyperdata & ui_cwImagePathL .~ Just (T.pack fpath)
      updateHyperdata (node_u ^. node_id) u_hyperdata'
  pure (IntResponse 0)
