{ pkgs ? import (if builtins.elem builtins.currentSystem ["x86_64-darwin" "aarch64-darwin"]
                 then ./pinned-25.05.darwin.nix
                 else ./pinned-25.05.nix) {} }:

rec {
  inherit pkgs;
  ghc966 = pkgs.haskell.compiler.ghc966;
  cabal_install = pkgs.haskell.lib.compose.justStaticExecutables pkgs.haskell.packages.ghc966.cabal-install;
  
  graphviz = pkgs.callPackage ./graphviz.nix {};
  igraph_0_10_4 = pkgs.callPackage ./igraph.nix {};
  corenlp = pkgs.callPackage ./corenlp.nix { };  # 4.5.8
  cabal2stack = pkgs.callPackage ./cabal2stack.nix { ghc = ghc966; };
  nng_notls = pkgs.nng.overrideAttrs (old: {
    cmakeFlags = (old.cmakeFlags or []) ++ [ "-DNNG_ENABLE_TLS=OFF" ];
  });
  
  hsBuildInputs = [
    ghc966
    cabal_install
    pkgs.haskellPackages.alex
    pkgs.haskellPackages.happy
    pkgs.haskellPackages.pretty-show
  ];
  nonhsBuildInputs = with pkgs; [
    #haskell-language-server
    blas
    bzip2
    cabal2stack
    corenlp
    curl
    czmq
    docker-compose
    expat
    gfortran
    git
    gmp
    graphviz
    gsl
    hlint
    icu
    igraph_0_10_4
    jre
    lapack
    libffi
    libpqxx
    libsodium
    nng_notls
    nil  # nix language server
    pcre
    pkg-config
    postgresql
    stdenv.cc.cc
    xz
    zlib
    zeromq
    curl
  ] ++ ( lib.optionals stdenv.isDarwin [
       darwin.apple_sdk.frameworks.Accelerate
       ]);
  libPaths = pkgs.lib.makeLibraryPath nonhsBuildInputs;
  shellHook = ''
    export LD_LIBRARY_PATH="${pkgs.gfortran.cc.lib}:${libPaths}:$LD_LIBRARY_PATH"
    export LIBRARY_PATH="${pkgs.gfortran.cc.lib}:${libPaths}"
    export PATH="${pkgs.gccStdenv}/bin:$PATH"
    export NIX_CC="${pkgs.gccStdenv}"
    export CC="${pkgs.gccStdenv}/bin/gcc"
  '';
  shell = pkgs.mkShell.override { stdenv = pkgs.gccStdenv; } {
    name = "gargantext-shell";
    buildInputs = hsBuildInputs ++ nonhsBuildInputs;
    inherit shellHook;
  };
}
