{ lib,
  ghc,
  haskellPackages,
  fetchFromGitHub }:

let
  src = fetchFromGitHub {
    repo = "cabal2stack";
    owner = "iconnect";
    rev = "e4960683f518ab4c964e7646706fe2a7e1bf751a";
    hash = "sha256-KE9VUXFy9QfRmu/+DFcgxV/E6oPBAR7hRaFrSt93eeY=";
  };
in
with haskellPackages;
mkDerivation {
  inherit src;
  pname = "cabal2stack";
  version = "0";
  isExecutable = true;
  executableHaskellDepends = [ base
                               aeson
                               cabal-plan
                               HsYAML
                               HsYAML-aeson
                               optics-core
                               optics-extra
                               optparse-applicative
                               transformers ];
  patches = [
    ./patches/cabal2stack.patch
  ];
  license = lib.licenses.bsd3;
  mainProgram = "cabal2stack"; 
}
