{-|
Module      : Core.Utils
Description :
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

module Test.Core.Utils where

import Gargantext.Core.Utils
import Gargantext.Prelude
import Test.Hspec

-- | Core.Utils tests
test :: Spec
test = do
  describe "check if groupWithCounts works" $ do
    it "simple integer array" $ groupWithCounts testArray  `shouldBe` groupedArray
    it "string"               $ groupWithCounts testString `shouldBe` groupedString
  describe "check nonemptyIntercalate" $ do
    it "empty list" $ nonemptyIntercalate "," [] `shouldBe` ""
    it "simple list" $ nonemptyIntercalate "," ["x"] `shouldBe` "x"
    it "two-element list" $ nonemptyIntercalate "," ["x", "y"] `shouldBe` "x,y"
    it "with empty strings" $ nonemptyIntercalate "," ["a", "", "b", "", "c", ""] `shouldBe` "a,b,c"
  where
    testArray :: [Int]
    testArray = [1, 2, 3, 1, 2, 3]
    groupedArray :: [(Int, Int)]
    groupedArray = [(1, 2), (2, 2), (3, 2)]
    testString :: [Char]
    testString = "abccba"
    groupedString :: [(Char, Int)]
    groupedString = [('a', 2), ('b', 2), ('c', 2)]
    
