module Gargantext.API.Node.Corpus.Subcorpus where

import Gargantext.Prelude

import Gargantext.API.Errors.Types (BackendInternalError)
import Gargantext.API.Routes.Named.Corpus (MakeSubcorpusAPI(..), SubcorpusParams(..))
import Gargantext.Core.NodeStory.Types (HasNodeStoryEnv)
import Gargantext.Core.NLP (HasNLPServer)
import Gargantext.Core.Text.Corpus (makeSubcorpusFromQuery)
import Gargantext.Core.Text.Corpus.Query (RawQuery(..), parseQuery)
import Gargantext.Core.Types (UserId)
import Gargantext.Core.Types.Individu (User(..))
import Gargantext.Database.Prelude (DbCmd')
import Servant.Server.Generic (AsServerT)


makeSubcorpus :: ( HasNodeStoryEnv env
                 , HasNLPServer    env
                 , DbCmd' env BackendInternalError m
                 )
  => UserId
  -> MakeSubcorpusAPI (AsServerT m)
makeSubcorpus user = MakeSubcorpusAPI $ \corpusId params -> do
  case parseQuery (RawQuery $ _subcorpusParams_query params) of
    Left _  -> return False
    Right q -> do
      _ <- makeSubcorpusFromQuery
             (UserDBId user)
             corpusId
             q
             (_subcorpusParams_reuseParentList params)
      return True
