{-|
Module      : Gargantext.API.Routes.Named.Document
Description : Document API
Copyright   : (c) CNRS, 2024
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

{-# LANGUAGE TypeOperators   #-}

module Gargantext.API.Routes.Named.Document (
  -- * Routes types
    DocumentsFromWriteNodesAPI(..)
  , DocumentUploadAPI(..)
  , DocumentExportAPI(..)
  , DocumentExportEndpoints(..)

  -- * API types
  , Params(..)
  , DocumentUpload(..)
  ) where

import Data.Text (Text)
import GHC.Generics
import Gargantext.API.Node.Document.Export.Types
import Gargantext.API.Node.DocumentsFromWriteNodes.Types ( Params(..) )
import Gargantext.API.Node.DocumentUpload.Types ( DocumentUpload(..),  )
import Gargantext.API.Worker (WorkerAPI)
import Gargantext.Utils.Servant (ZIP)
import Servant

newtype DocumentExportAPI mode = DocumentExportAPI
  { documentExportAPI :: mode :- Summary "Document Export" :> "export" :> NamedRoutes DocumentExportEndpoints
  } deriving Generic

data DocumentExportEndpoints mode = DocumentExportEndpoints
  { exportJSONEp :: mode :- "json"
                         :> Get '[JSON] (Headers '[Servant.Header "Content-Disposition" Text] DocumentExport)
  , exportJSONZipEp :: mode :- "json.zip"
                            :> Get '[ZIP] (Headers '[Servant.Header "Content-Disposition" Text] DocumentExportZIP)
  , exportTSVEp :: mode :- "tsv"
                        :> Get '[PlainText] (Headers '[Servant.Header "Content-Disposition" Text] Text)
  } deriving Generic

newtype DocumentsFromWriteNodesAPI mode = DocumentsFromWriteNodesAPI
  { docFromWriteNodesEp :: mode :- Summary " Documents from Write nodes."
                                :> NamedRoutes (WorkerAPI '[JSON] Params)
  } deriving Generic


newtype DocumentUploadAPI mode = DocumentUploadAPI
  { uploadDocAsyncEp :: mode :- Summary " Document upload"
                             :> "document"
                             :> "upload"
                             :> "async"
                             :> NamedRoutes (WorkerAPI '[JSON] DocumentUpload)
  } deriving Generic
