{-|
Module      : Gargantext.Core.Notifications
Description : Asynchronous updates to the frontend
Copyright   : (c) CNRS, 2024-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX
-}


module Gargantext.Core.Notifications
where

import Gargantext.Core.Config.Types (NotificationsConfig)
import Gargantext.Core.Notifications.CentralExchange qualified as CE
import Gargantext.Core.Notifications.Dispatcher qualified as D
import Protolude


withNotifications :: NotificationsConfig -> (D.Dispatcher -> IO a) -> IO a
withNotifications nc cb =
  D.withDispatcher nc $ \dispatcher -> do
    withAsync (CE.gServer nc) $ \_ce -> do
      cb dispatcher
