{-|
Module      : Gargantext.API.Node.Post
Description :
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

New = Post maybe change the name
Async new node feature

-}

{-# LANGUAGE TemplateHaskell    #-}
{-# LANGUAGE TypeOperators      #-}

{-# LANGUAGE IncoherentInstances #-}
module Gargantext.API.Node.New
      where

import Control.Lens hiding (elements, Empty)
import Gargantext.API.Admin.Auth.Types
import Gargantext.API.Admin.EnvTypes (GargJob(..), Env)
import Gargantext.API.Admin.Orchestrator.Types (AsyncJobs (..))
import Gargantext.API.Errors.Types
import Gargantext.API.Node.New.Types
import Gargantext.API.Prelude
import Gargantext.API.Routes.Named.Node qualified as Named
import Gargantext.Core.AsyncUpdates.CentralExchange.Types qualified as CE
import Gargantext.Core.Mail.Types (HasMail)
import Gargantext.Core.NLP (HasNLPServer)
import Gargantext.Core.Worker.Jobs qualified as Jobs
import Gargantext.Core.Worker.Jobs.Types qualified as Jobs
import Gargantext.Database.Action.Node
import Gargantext.Database.Admin.Types.Node
import Gargantext.Database.Prelude (CmdM, DBCmd')
import Gargantext.Database.Query.Table.Node.Error (HasNodeError(..))
import Gargantext.Prelude
import Gargantext.Utils.Jobs (serveJobsAPI)
import Servant.Server.Generic (AsServerT)

------------------------------------------------------------------------
-- postNode :: (CmdM env err m, HasNodeError err, HasSettings env)
postNode :: ( HasMail env
            , HasNodeError err
            , HasNLPServer env
            , CE.HasCentralExchangeNotification env)
         => AuthenticatedUser
         -- ^ The logged-in user
         -> NodeId
         -> PostNode
         -- -> m [NodeId]
         -> DBCmd' env err [NodeId]
postNode authenticatedUser nId pn = do
  postNode' authenticatedUser nId pn

postNodeAsyncAPI
  :: AuthenticatedUser
  -- ^ The logged-in user
  -> NodeId
  -- ^ The target node
  -> Named.PostNodeAsyncAPI (AsServerT (GargM Env BackendInternalError))
postNodeAsyncAPI authenticatedUser nId = Named.PostNodeAsyncAPI $ AsyncJobs $
  serveJobsAPI NewNodeJob $ \_jHandle p -> do
    Jobs.sendJob $ Jobs.NewNodeAsync { Jobs._nna_node_id = nId
                                     , Jobs._nna_authenticatedUser = authenticatedUser
                                     , Jobs._nna_postNode = p }
    -- postNodeAsync authenticatedUser nId p jHandle

------------------------------------------------------------------------
-- postNode' :: (CmdM env err m, HasSettings env, HasNodeError err)
--           => AuthenticatedUser
--           -- ^ The logged-in user
--           -> NodeId
--           -> PostNode
--           -> m [NodeId]
-- postNode' authenticatedUser pId (PostNode nodeName nt) = do
postNode' :: ( CmdM env err m
             , HasNodeError err
             , HasMail env
             , CE.HasCentralExchangeNotification env)
    => AuthenticatedUser
    -- ^ The logged in user
    -> NodeId
    -> PostNode
    -> m [NodeId]
postNode' authenticatedUser nId (PostNode nodeName tn) = do

  let userId = authenticatedUser ^. auth_user_id
  nodeIds <- mkNodeWithParent tn (Just nId) userId nodeName

  -- mapM_ (CE.ce_notify . CE.UpdateTreeFirstLevel) nodeIds
  CE.ce_notify $ CE.UpdateTreeFirstLevel nId

  return nodeIds


-- postNodeAsync :: (FlowCmdM env err m, MonadJobStatus m, HasSettings env)
--     => AuthenticatedUser
--     -- ^ The logged in user
--     -> NodeId
--     -> PostNode
--     -> JobHandle m
--     -> m ()
-- postNodeAsync authenticatedUser nId (PostNode nodeName tn) jobHandle = do

--   -- printDebug "postNodeAsync" nId
--   markStarted 3 jobHandle
--   markProgress 1 jobHandle

--   -- _ <- threadDelay 1000
--   markProgress 1 jobHandle

--   let userId = authenticatedUser ^. auth_user_id
--   _ <- mkNodeWithParent tn (Just nId) userId nodeName

--   markComplete jobHandle
