{-|
Module      : Gargantext.API.Members
Description :
Copyright   : (c) CNRS, 2017
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX
-}

module Gargantext.API.Members where

import Gargantext.API.Prelude (IsGargServer)
import Gargantext.API.Routes.Named.Private qualified as Named
import Gargantext.Database.Action.Share (membersOf)
import Gargantext.Database.Admin.Types.Node (NodeType(NodeTeam))
import Gargantext.Database.Query.Table.Node (getNodesIdWithType)
import Gargantext.Prelude
import Servant.Server.Generic (AsServerT)

members :: IsGargServer err env m => Named.MembersAPI (AsServerT m)
members = Named.MembersAPI getMembers

getMembers :: IsGargServer err env m => m [Text]
getMembers = do
  teamNodeIds <- getNodesIdWithType NodeTeam
  m <- concatMapM membersOf teamNodeIds
  pure $ map fst m
