{-|
Module      : Gargantext.Core.Notifications
Description : Asynchronous updates to the frontend
Copyright   : (c) CNRS, 2024-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX
-}


module Gargantext.Core.Notifications
where

import Gargantext.Core.Config (GargConfig)
import Gargantext.Core.Notifications.CentralExchange qualified as CE
import Gargantext.Core.Notifications.Dispatcher qualified as D
import Protolude


withNotifications :: GargConfig -> (D.Dispatcher -> IO a) -> IO a
withNotifications gc cb =
  D.withDispatcher gc $ \dispatcher -> do
    withAsync (CE.gServer gc) $ \_ce -> do
      cb dispatcher
