{-# LANGUAGE TypeFamilies #-}

module Test.API.Private.Table (
    tests
  ) where

import Gargantext.API.HashedResponse
import Gargantext.API.Ngrams.Types qualified as APINgrams
import Gargantext.Core.Text.Corpus.Query
import Gargantext.Core.Types
import Gargantext.Core.Types.Individu
import Gargantext.Database.Query.Facet qualified as Facet
import Gargantext.Prelude
import Servant.Client
import Test.API.Prelude (checkEither)
import Test.API.Routes
import Test.API.Setup (SpecContext(..), dbEnvSetup, withTestDBAndPort)
import Test.API.UpdateList (createDocsList)
import Test.Hspec
import Test.Hspec.Wai.Internal (withApplication)
import Test.Utils


tests :: Spec
tests = sequential $ aroundAll withTestDBAndPort $ beforeAllWith dbEnvSetup $ do
  describe "Prelude" $ do
    beforeAllWith createSoySauceCorpus $ do
      it "should return sauce in the search (#415)" $ \SpecContext{..} -> do
        let corpusId = _sctx_data
        withApplication _sctx_app $ do
          withValidLogin _sctx_port "alice" (GargPassword "alice") $ \clientEnv token -> do
            liftIO $ do
              (HashedResponse _ tr1)
                <- checkEither $ runClientM (get_table token
                                                       corpusId
                                                       (Just APINgrams.Docs)
                                                       (Just 10)
                                                       (Just 0)
                                                       (Just Facet.DateDesc)
                                                       (Just $ RawQuery "sauce")
                                                       Nothing
                                            ) clientEnv
              length (tr_docs tr1) `shouldBe` 1

      it "should return soy in the search (#415)" $ \SpecContext{..} -> do
        let corpusId = _sctx_data
        withApplication _sctx_app $ do
          withValidLogin _sctx_port "alice" (GargPassword "alice") $ \clientEnv token -> do

            liftIO $ do
              (HashedResponse _ tr1)
                <- checkEither $ runClientM (get_table token
                                                       corpusId
                                                       (Just APINgrams.Docs)
                                                       (Just 10)
                                                       (Just 0)
                                                       (Just Facet.DateDesc)
                                                       (Just $ RawQuery "soy")
                                                       Nothing
                                            ) clientEnv

              length (tr_docs tr1) `shouldBe` 3

createSoySauceCorpus :: SpecContext () -> IO (SpecContext CorpusId)
createSoySauceCorpus ctx@SpecContext{..} = do
  withApplication _sctx_app $ do
    withValidLogin _sctx_port "alice" (GargPassword "alice") $ \clientEnv token -> do
      corpusId <- createDocsList "test-data/search/GarganText_DocsList-soysauce.json" _sctx_env _sctx_port clientEnv token
      pure $ const corpusId <$> ctx
