{-|
Module      : Gargantext.API.Named.Corpus
Description :
Copyright   : (c) CNRS, 2017
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX
-}

{-# LANGUAGE TypeOperators #-}
{-# LANGUAGE TemplateHaskell #-}

module Gargantext.API.Routes.Named.Corpus (
  -- * Routes types
    CorpusExportAPI(..)
  , AddWithTempFile(..)
  , AddWithQuery(..)
  , MakeSubcorpusAPI(..)
  -- * Others
  , SubcorpusParams(..)
  ) where

import Data.Aeson.TH (deriveJSON)
import Data.Swagger (ToSchema(..), genericDeclareNamedSchema)
import Data.Text (Text)
import GHC.Generics (Generic)
import Gargantext.API.Node.Corpus.Export.Types (Corpus, CorpusSQLite)
import Gargantext.API.Node.Types (NewWithForm, WithQuery)
import Gargantext.API.Worker (WorkerAPI)
import Gargantext.Core.Text.Ngrams (NgramsType(..))
import Gargantext.Core.Utils.Prefix (unPrefix, unPrefixSwagger)
import Gargantext.Database.Admin.Types.Node (CorpusId, ListId, NodeId)
import Gargantext.Prelude (Bool)
import Servant

--------------------------------------------------
data CorpusExportAPI mode = CorpusExportAPI
  { corpusExportEp :: mode :- Summary "Corpus Export"
                           :> "export"
                           :> QueryParam "listId"     ListId
                           :> QueryParam "ngramsType" NgramsType
                           :> Get '[JSON] (Headers '[Servant.Header "Content-Disposition" Text] Corpus)
  , corpusSQLiteEp :: mode :- Summary "Corpus SQLite export"
                           :> "sqlite"
                           :> QueryParam "listId" ListId
                           :> Get '[OctetStream] (Headers '[Servant.Header "Content-Disposition" Text] CorpusSQLite)
  } deriving Generic


data AddWithTempFile mode = AddWithTempFile
  { addWithTempFileEp :: mode :- Summary "Add with form via temp file"
                              :> "corpus"
                              :> Capture "corpus_id" CorpusId
                              :> "add"
                              :> "form"
                              :> "async"
                              :> NamedRoutes (WorkerAPI '[FormUrlEncoded] NewWithForm)
  } deriving Generic

newtype AddWithQuery mode = AddWithQuery
  { addWithQueryEp :: mode :- Summary "Add with Query to corpus endpoint"
                           :> "corpus"
                           :> Capture "corpus_id" CorpusId
                           :> "query"
                           :> NamedRoutes (WorkerAPI '[JSON] WithQuery)
  } deriving Generic

newtype MakeSubcorpusAPI mode = MakeSubcorpusAPI
  { makeSubcorpusAPI :: mode :- Summary "Make a subcorpus based on a text search"
                     :> "corpus"
                     :> Capture "corpus_id" CorpusId
                     :> "subcorpus"
                     :> ReqBody '[JSON] SubcorpusParams
                     :> Post '[JSON] NodeId -- new subcorpus ID
  } deriving Generic

data SubcorpusParams = SubcorpusParams
  { _subcorpusParams_query           :: Text
  , _subcorpusParams_reuseParentList :: Bool
  } deriving Generic

$(deriveJSON (unPrefix "_subcorpusParams_") ''SubcorpusParams)

instance ToSchema SubcorpusParams where
  declareNamedSchema = genericDeclareNamedSchema (unPrefixSwagger "_subcorpusParams_")
