{--|
Module      : Main.hs
Description : Main for Gargantext Tasty Tests
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX
-}

module Main where

import Gargantext.Prelude

import qualified Test.Core.Text.Corpus.Query     as CorpusQuery
import qualified Test.Core.Text.Corpus.TSV       as TSVParser
import qualified Test.Core.Utils                 as Utils
import qualified Test.Core.Worker                as Worker
import qualified Test.Graph.Clustering           as Graph
import qualified Test.Ngrams.NLP                 as NLP
import qualified Test.Ngrams.Query               as NgramsQuery
import qualified Test.Offline.JSON               as JSON
import qualified Test.Offline.Errors             as Errors
import qualified Test.Offline.Phylo              as Phylo
import qualified Test.Offline.Stemming.Lancaster as Lancaster
import qualified Test.Parsers.Date               as PD
import qualified Test.Utils.Crypto               as Crypto
import qualified Test.Utils.Jobs                 as Jobs
import qualified Test.Core.Similarity            as Similarity
import qualified Test.Core.Notifications          as Notifications

import Test.Tasty
import Test.Tasty.Hspec

main :: IO ()
main = do
  utilSpec         <- testSpec "Utils" Utils.test
  clusteringSpec   <- testSpec "Graph Clustering" Graph.test
  dateSplitSpec    <- testSpec "Date split" PD.testDateSplit
  cryptoSpec       <- testSpec "Crypto" Crypto.test
  nlpSpec          <- testSpec "NLP" NLP.test
  jobsSpec         <- testSpec "Jobs" Jobs.test
  similaritySpec   <- testSpec "Similarity" Similarity.test
  asyncUpdatesSpec <- testSpec "Notifications" Notifications.test

  defaultMain $ testGroup "Gargantext"
    [ utilSpec
    , clusteringSpec
    , dateSplitSpec
    , cryptoSpec
    , nlpSpec
    , jobsSpec
    , NgramsQuery.tests
    , CorpusQuery.tests
    , TSVParser.tests
    , JSON.tests
    , Errors.tests
    , similaritySpec
    , Phylo.tests
    , testGroup "Stemming" [ Lancaster.tests ]
    , Worker.tests
    , Jobs.qcTests
    , asyncUpdatesSpec
    , Notifications.qcTests
    ]
