{-|
Module      : Gargantext.API.Node.Post
Description :
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

New = Post maybe change the name
Async new node feature

-}

{-# LANGUAGE IncoherentInstances #-}

module Gargantext.API.Node.New
      where

import Control.Lens hiding (elements, Empty)
import Gargantext.API.Admin.Auth.Types (AuthenticatedUser, auth_user_id)
import Gargantext.API.Admin.EnvTypes (Env)
import Gargantext.API.Errors.Types (BackendInternalError)
import Gargantext.API.Node.New.Types (PostNode(..))
import Gargantext.API.Prelude (GargM)
import Gargantext.API.Routes.Named.Node qualified as Named
import Gargantext.API.Worker (serveWorkerAPI)
import Gargantext.Core.Mail.Types (HasMail)
import Gargantext.Core.Notifications.CentralExchange.Types qualified as CE
import Gargantext.Core.NLP (HasNLPServer)
import Gargantext.Core.Worker.Jobs.Types qualified as Jobs
import Gargantext.Database.Action.Node (mkNodeWithParent)
import Gargantext.Database.Admin.Types.Node
import Gargantext.Database.Prelude (IsDBCmdExtra, DBCmdWithEnv)
import Gargantext.Database.Query.Table.Node.Error (HasNodeError(..))
import Gargantext.Prelude
import Servant.Server.Generic (AsServerT)

------------------------------------------------------------------------
-- postNode :: (CmdM env err m, HasNodeError err, HasSettings env)
postNode :: ( HasMail env
            , HasNodeError err
            , HasNLPServer env
            , CE.HasCentralExchangeNotification env)
         => AuthenticatedUser
         -- ^ The logged-in user
         -> NodeId
         -> PostNode
         -- -> m [NodeId]
         -> DBCmdWithEnv env err [NodeId]
postNode authenticatedUser nId pn = do
  postNode' authenticatedUser nId pn

postNodeAsyncAPI
  :: AuthenticatedUser
  -- ^ The logged-in user
  -> NodeId
  -- ^ The target node
  -> Named.PostNodeAsyncAPI (AsServerT (GargM Env BackendInternalError))
postNodeAsyncAPI authenticatedUser nId =
  Named.PostNodeAsyncAPI {
    postNodeAsyncEp = serveWorkerAPI $ \p ->
        Jobs.PostNodeAsync { _pna_node_id = nId
                           , _pna_authenticatedUser = authenticatedUser
                           , _pna_args = p }
  }

------------------------------------------------------------------------
-- postNode' :: (CmdM env err m, HasSettings env, HasNodeError err)
--           => AuthenticatedUser
--           -- ^ The logged-in user
--           -> NodeId
--           -> PostNode
--           -> m [NodeId]
-- postNode' authenticatedUser pId (PostNode nodeName nt) = do
postNode' :: ( IsDBCmdExtra env err m
             , HasNodeError err
             , HasMail env
             , CE.HasCentralExchangeNotification env)
    => AuthenticatedUser
    -- ^ The logged in user
    -> NodeId
    -> PostNode
    -> m [NodeId]
postNode' authenticatedUser nId (PostNode nodeName tn) = do

  let userId = authenticatedUser ^. auth_user_id
  nodeIds <- mkNodeWithParent tn (Just nId) userId nodeName

  -- mapM_ (CE.ce_notify . CE.UpdateTreeFirstLevel) nodeIds
  CE.ce_notify $ CE.UpdateTreeFirstLevel nId

  return nodeIds


-- postNodeAsync :: (FlowCmdM env err m, MonadJobStatus m, HasSettings env)
--     => AuthenticatedUser
--     -- ^ The logged in user
--     -> NodeId
--     -> PostNode
--     -> JobHandle m
--     -> m ()
-- postNodeAsync authenticatedUser nId (PostNode nodeName tn) jobHandle = do

--   -- printDebug "postNodeAsync" nId
--   markStarted 3 jobHandle
--   markProgress 1 jobHandle

--   -- _ <- threadDelay 1000
--   markProgress 1 jobHandle

--   let userId = authenticatedUser ^. auth_user_id
--   _ <- mkNodeWithParent tn (Just nId) userId nodeName

--   markComplete jobHandle
