{-|
Module      : Gargantext.API.Node.New.Types
Description : 
Copyright   : (c) CNRS, 2024-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

module Gargantext.API.Node.New.Types (
  PostNode(..)
  ) where

import Data.Aeson
import Data.Swagger
import GHC.Generics
import Gargantext.Core.Types (NodeType (..))
import Gargantext.Prelude
import Test.QuickCheck
import Web.FormUrlEncoded

------------------------------------------------------------------------
data PostNode = PostNode { pn_name     :: Text
                         , pn_typename :: NodeType }
  deriving (Generic, Eq, Show)
------------------------------------------------------------------------
-- TODO unPrefix "pn_" FromJSON, ToJSON, ToSchema, adapt frontend.
instance FromJSON  PostNode
instance ToJSON    PostNode
instance ToSchema  PostNode
instance FromForm  PostNode
instance ToForm    PostNode
instance Arbitrary PostNode where
  arbitrary = elements [PostNode "Node test" NodeCorpus]

