{-# LANGUAGE TypeOperators #-}

module Gargantext.API.Routes.Named.File (
  -- * Routes types
    FileAPI(..)
  , FileAsyncAPI(..)
  ) where

import Data.Text (Text)
import GHC.Generics (Generic)
import Gargantext.API.Node.File.Types (BSResponse, RESPONSE)
import Gargantext.API.Node.Types (NewWithFile)
import Gargantext.API.Worker (WorkerAPI)
import Servant

data FileAPI mode = FileAPI
  { fileDownloadEp :: mode :- Summary "File download"
                           :> "download"
                           :> Get '[RESPONSE] (Headers '[Servant.Header "Content-Type" Text] BSResponse)
  } deriving Generic


data FileAsyncAPI mode = FileAsyncAPI
  { addFileAsyncEp :: mode :- Summary "File Async Api"
                           :> "file"
                           :> "add"
                           :> NamedRoutes (WorkerAPI '[FormUrlEncoded] NewWithFile)
  } deriving Generic

