
module Gargantext.Core.Text.Corpus.Parsers.Types where

import Data.ByteString
import Data.Csv
import Data.Text
import Prelude

-- | Allows the parser to report errors happening at a given row in the document.
data AtRow a = AtRow Int a
  deriving Show

data ParseCorpusResult a
  = ParseRecordSucceeded a
  | ParseTsvRecordFailed (AtRow (Text, ByteString))
  deriving Show

instance FromNamedRecord a => FromNamedRecord (ParseCorpusResult a) where
  parseNamedRecord m = ParseRecordSucceeded <$> parseNamedRecord m
