{-|
Module      : Gargantext.API.Routes.Named.Publish
Description : 
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX
-}

{-# LANGUAGE TypeOperators #-}

module Gargantext.API.Routes.Named.Publish (
    PublishRequest(..)
  , PublishAPI(..)
  ) where

import Data.Aeson as JS
import Data.Swagger (ToSchema)
import Gargantext.Database.Query.Table.NodeNode (NodePublishPolicy)
import GHC.Generics (Generic)
import Prelude
import Servant

newtype PublishRequest = PublishRequest
  { pubrq_policy :: NodePublishPolicy
  } deriving (Show, Eq, Generic)

instance ToSchema PublishRequest

instance ToJSON PublishRequest where
  toJSON (PublishRequest pol) =
    JS.object [ "policy" JS..= toJSON pol ]

instance FromJSON PublishRequest where
  parseJSON = withObject "PublishRequest" $ \o -> do
    pubrq_policy <- o JS..: "policy"
    pure $ PublishRequest{..}

newtype PublishAPI mode = PublishAPI
  { publishEp :: mode :- Summary "Publish a Corpus Node"
                      :> ReqBody '[JSON] PublishRequest
                      :> Delete '[JSON] Int
  } deriving Generic
