{-# LANGUAGE TypeOperators        #-}
{-# LANGUAGE ScopedTypeVariables  #-}

module Gargantext.API.Node.ShareURL where

import Data.Text
import Gargantext.Prelude
import Gargantext.API.Prelude
import Gargantext.Core.Types (NodeType, NodeId, unNodeId)
import Gargantext.Database.Prelude (HasConfig (hasConfig), CmdCommon)
import Control.Lens.Getter (view)
import Gargantext.Core.Config (gc_url)
import Gargantext.API.Routes.Named.Share qualified as Named
import Servant.Server.Generic (AsServerT)

shareURL :: IsGargServer env err m => Named.ShareURL (AsServerT m)
shareURL = Named.ShareURL getUrl

getUrl :: (IsGargServer env err m, CmdCommon env)
       => Maybe NodeType
       -> Maybe NodeId
       -> m Text
getUrl nt id = do
-- TODO add check that the node is able to be shared (in a shared folder)
    case nt of
        Nothing -> pure "Invalid node Type"
        Just t ->
            case id of
                Nothing -> pure "Invalid node ID"
                Just i -> do
                    url <- view $ hasConfig . gc_url
                    pure $ url <> "/#/share/" <> show t <> "/" <> show (unNodeId i)
