{-# LANGUAGE TypeOperators #-}

module Gargantext.API.Routes.Named.Public (
  -- * Routes types
    GargPublicAPI'(..)
  , GargPublicAPI(..)
  , HomeAPI(..)
  , NodeAPI(..)
  ) where

import GHC.Generics (Generic)
import Gargantext.API.Public.Types qualified as Public
import Gargantext.API.Routes.Named.File (FileAPI)
import Gargantext.Database.Admin.Types.Node ( NodeId )
import Servant.API

newtype GargPublicAPI mode = GargPublicAPI
  { gargAPIVersion :: mode :- "public" :> NamedRoutes GargPublicAPI'
  } deriving Generic

data GargPublicAPI' mode = GargPublicAPI'
  { publicHomeAPI :: mode :- NamedRoutes HomeAPI
  , publicNodeAPI :: mode :- NamedRoutes NodeAPI
  } deriving Generic


data HomeAPI mode = HomeAPI
  { homeEp :: mode :- Summary "Public Home API" :> Get '[JSON] [Public.PublicData]
  } deriving Generic


data NodeAPI mode = NodeAPI
  { nodeEp :: mode :- Summary "Public Node API" :> Capture "node" NodeId :> "file" :> NamedRoutes FileAPI
  } deriving Generic
