{-|
Module      : Upgrade.hs
Description : Gargantext Import Corpus
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

Upgrade a gargantext node.

 -}

{-# LANGUAGE Strict            #-}
{-# LANGUAGE QuasiQuotes       #-}

module CLI.Upgrade where

import CLI.Types
import CLI.Parsers
import Data.List qualified as List (cycle, concat, take, unlines)
import Gargantext.API.Dev (withDevEnv)
import Gargantext.API.Node () -- instances only
import Gargantext.Core.Config (GargConfig(..))
import Gargantext.Core.Config.Types (SecretsConfig(..))
import Gargantext.Core.Config.Utils (readConfig)
import Gargantext.Prelude
import Options.Applicative
import Prelude qualified

upgradeCLI :: UpgradeArgs -> IO ()
upgradeCLI (UpgradeArgs settingsFile) = do

  let ___ = putStrLn ((List.concat
                       $ List.take 72
                       $ List.cycle ["_"]) :: Prelude.String)

  ___
  putStrLn ("GarganText upgrade to version 0.0.6.9.9.4.4" :: Text)
  ___

  putStrLn $ List.unlines
           [ "Your Database defined in gargantext.ini will be upgraded."
           , "We stronlgy recommend you to make a backup using pg_dump."
           , ""
           , "Press ENTER if you want to continue, CTRL+C if you want to stop."
           ]

  _ok  <- getLine

  cfg       <- readConfig settingsFile
  let _secret = _s_secret_key $ _gc_secrets cfg

  withDevEnv settingsFile $ \_env -> do
    putStrLn ("Uprade done with success !" :: Text)
    pure ()

upgradeCmd :: HasCallStack => Mod CommandFields CLI
upgradeCmd = command "upgrade" (info (helper <*> fmap CLISub upgrade_p) (progDesc "Upgrade a Gargantext node."))

upgrade_p :: Parser CLICmd
upgrade_p = fmap CCMD_upgrade $ UpgradeArgs
  <$> settings_p
