{-|
Module      : Gargantext.Core.Config.Utils
Description :
Copyright   : (c) CNRS, 2024-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

module Gargantext.Core.Config.Utils (
    readConfig
  )
  where

import Gargantext.Core.Config.Types (SettingsFile(..))
import Gargantext.Prelude
-- import Network.URI (URI)
-- import Network.URI (parseURI)
import Toml
import Toml.Schema


readConfig :: FromValue a => SettingsFile -> IO a
readConfig (SettingsFile fp) = do
  c <- readFile fp

  case decode c of
    Failure err -> panicTrace ("Error reading TOML file: " <> show err)
    Success _ r -> return r


-- _URI :: Toml.TomlBiMap URI Text
-- _URI = Toml.BiMap (Right . show) parseURI'
--   where
--     parseURI' :: Text -> Either Toml.TomlBiMapError URI
--     parseURI' t =
--       case parseURI (T.unpack t) of
--         Nothing -> Left $ Toml.ArbitraryError "Cannot parse URI"
--         Just u -> Right u

-- uriToml :: Toml.Key -> Toml.TomlCodec URI
-- uriToml = Toml.match (_URI >>> Toml._Text)


-- _Word16 :: Toml.TomlBiMap Word16 Toml.AnyValue
-- _Word16 = Toml._BoundedInteger >>> Toml._Integer


-- word16Toml :: Toml.Key -> Toml.TomlCodec Word16
-- word16Toml = Toml.match _Word16
