{-# LANGUAGE TypeOperators #-}

module Gargantext.API.Routes.Named.Metrics (
  -- * Routes types

    TreeAPI(..)
  , ScatterAPI(..)
  , ChartAPI(..)
  , PieAPI(..)
  ) where

import Data.Text (Text)
import Data.Time (UTCTime)
import Data.Vector (Vector)
import GHC.Generics (Generic)
import Gargantext.API.HashedResponse (HashedResponse)
import Gargantext.API.Ngrams.NgramsTree (NgramsTree)
import Gargantext.API.Ngrams.Types (QueryParamR, TabType)
import Gargantext.Core.Types.Main (ListType)
import Gargantext.Core.Types.Query (Limit)
import Gargantext.Core.Viz.Types (Histo)
import Gargantext.Database.Admin.Types.Metrics (ChartMetrics, Metrics)
import Gargantext.Database.Admin.Types.Node (ListId)
import Servant


data TreeAPI mode = TreeAPI
  { treeChartEp       :: mode :- Summary " Tree API"
                              :> QueryParam "from" UTCTime
                              :> QueryParam "to"   UTCTime
                              :> QueryParam  "list"       ListId
                              :> QueryParamR "ngramsType" TabType
                              :> QueryParamR "listType"   ListType
                              :> Get '[JSON] (HashedResponse (ChartMetrics (Vector NgramsTree)))
  , treeChartUpdateEp :: mode :- Summary "Tree Chart update"
                              :> QueryParam  "list"       ListId
                              :> QueryParamR "ngramsType" TabType
                              :> QueryParamR "listType"   ListType
                              :> Post '[JSON] ()
  , treeHashEp        :: mode :- "hash"
                              :> Summary "Tree Hash"
                              :> QueryParam  "list"       ListId
                              :> QueryParamR "ngramsType" TabType
                              :> QueryParamR "listType"   ListType
                              :> Get '[JSON] Text
  } deriving Generic


data ScatterAPI mode = ScatterAPI
  { sepGenEp :: mode :- Summary "SepGen IncExc metrics"
                     :> QueryParam  "list"       ListId
                     :> QueryParamR "ngramsType" TabType
                     :> QueryParam  "limit"      Limit
                     :> Get '[JSON] (HashedResponse Metrics)
  , scatterUpdateEp :: mode :- Summary "Scatter update"
                            :> QueryParam  "list"       ListId
                            :> QueryParamR "ngramsType" TabType
                            :> QueryParam  "limit"      Limit
                            :> Post '[JSON] ()
  , scatterHashEp :: mode :- "hash"
                          :> Summary "Scatter Hash"
                          :> QueryParam  "list"       ListId
                          :> QueryParamR "ngramsType" TabType
                          :> Get '[JSON] Text
  } deriving Generic


data PieAPI mode = PieAPI
  { getPieChartEp :: mode :- Summary "Pie Chart"
                          :> QueryParam "from" UTCTime
                          :> QueryParam "to"   UTCTime
                          :> QueryParam  "list"       ListId
                          :> QueryParamR "ngramsType" TabType
                          :> Get '[JSON] (HashedResponse (ChartMetrics Histo))
  , pieChartUpdateEp :: mode :- Summary "Pie Chart update"
                             :> QueryParam  "list"       ListId
                             :> QueryParamR "ngramsType" TabType
                             :> QueryParam  "limit"      Limit
                             :> Post '[JSON] ()
  , pieHashEp :: mode :- "hash"
                      :> Summary "Pie Hash"
                      :> QueryParam  "list"       ListId
                      :> QueryParamR "ngramsType" TabType
                      :> Get '[JSON] Text
  } deriving Generic


data ChartAPI mode = ChartAPI
  { getChartEp :: mode :- Summary " Chart API"
                       :> QueryParam "from" UTCTime
                       :> QueryParam "to"   UTCTime
                       :> QueryParam  "list"       ListId
                       :> QueryParamR "ngramsType" TabType
                       :> Get '[JSON] (HashedResponse (ChartMetrics Histo))
  , updateChartEp :: mode :- Summary "Chart update"
                          :> QueryParam  "list"       ListId
                          :> QueryParamR "ngramsType" TabType
                          :> QueryParam  "limit"      Limit
                          :> Post '[JSON] ()
  , chartHashEp :: mode :- "hash"
                        :> Summary "Chart Hash"
                        :> QueryParam  "list"       ListId
                        :> QueryParamR "ngramsType" TabType
                        :> Get '[JSON] Text
  } deriving Generic

