{-|
Module      : Gargantext.API.Named.Corpus
Description :
Copyright   : (c) CNRS, 2017
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX
-}

{-# LANGUAGE TypeOperators #-}

module Gargantext.API.Routes.Named.Corpus (
  -- * Routes types
    CorpusExportAPI(..)
  , AddWithForm(..)
  , AddWithQuery(..)
  ) where

import Data.Text (Text)
import GHC.Generics
-- import Gargantext.API.Admin.Orchestrator.Types
import Gargantext.API.Node.Corpus.Export.Types
import Gargantext.API.Node.Types
import Gargantext.API.Worker (WorkerAPI)
import Gargantext.Core.Text.Ngrams (NgramsType(..))
import Gargantext.Database.Admin.Types.Node
import Servant

--------------------------------------------------
newtype CorpusExportAPI mode = CorpusExportAPI
  { corpusExportEp :: mode :- Summary "Corpus Export"
                           :> "export"
                           :> QueryParam "listId"     ListId
                           :> QueryParam "ngramsType" NgramsType
                           :> Get '[JSON] (Headers '[Servant.Header "Content-Disposition" Text] Corpus)
  } deriving Generic

newtype AddWithForm mode = AddWithForm
  { addWithFormEp :: mode :- Summary "Add with FormUrlEncoded to corpus endpoint"
                          :> "corpus"
                          :> Capture "corpus_id" CorpusId
                          :> "add"
                          :> "form"
                          :> "async"
                          :> NamedRoutes (WorkerAPI '[FormUrlEncoded] NewWithForm)
  } deriving Generic

newtype AddWithQuery mode = AddWithQuery
  { addWithQueryEp :: mode :- Summary "Add with Query to corpus endpoint"
                           :> "corpus"
                           :> Capture "corpus_id" CorpusId
                           :> "query"
                           :> NamedRoutes (WorkerAPI '[JSON] WithQuery)
  } deriving Generic
