{-# LANGUAGE TemplateHaskell #-}
module Gargantext.API.Table.Types (
    TableQuery(..)
  , FacetTableResult
  ) where

import Data.Swagger (ToSchema(..), genericDeclareNamedSchema)
import Gargantext.API.Ngrams.Types (TabType(..))
import Gargantext.Core.Text.Corpus.Query (RawQuery)
import Gargantext.Core.Types (TableResult(..))
import Gargantext.Core.Types.Query (Offset, Limit)
import Gargantext.Core.Utils.Prefix (unPrefix, unPrefixSwagger)
import Gargantext.Database.Query.Facet (FacetDoc , OrderBy(..))
import Gargantext.Prelude

data TableQuery = TableQuery
  { tq_offset       :: Offset
  , tq_limit        :: Limit
  , tq_orderBy      :: OrderBy
  , tq_view         :: TabType
  , tq_query        :: RawQuery
  } deriving (Generic)

type FacetTableResult = TableResult FacetDoc

$(deriveJSON (unPrefix "tq_") ''TableQuery)

instance ToSchema TableQuery where
  declareNamedSchema = genericDeclareNamedSchema (unPrefixSwagger "tq_")
