{-|
Module      : Gargantext.API.GraphQL.IMT
Description : 
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX
-}


{-# LANGUAGE DeriveAnyClass #-}
{-# LANGUAGE DerivingStrategies #-}

module Gargantext.API.GraphQL.IMT
  ( School(..)
  , SchoolsArgs(..)
  , resolveSchools
  )
  where

import Data.Morpheus.Types (GQLType)
import Gargantext.API.GraphQL.Types
import Gargantext.Core.Ext.IMT (School(..), schools)
import Gargantext.Prelude

newtype SchoolsArgs
  = SchoolsArgs ()
    deriving stock (Generic)
    deriving anyclass (GQLType)

resolveSchools
  :: GqlM e env [School]
resolveSchools = pure $ schools
