{-|
Module      : Gargantext.API.GraphQL.Utils
Description : Utils for GraphQL API
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX
-}

{-# OPTIONS_GHC -Wno-deprecations #-} -- FIXME(adn) GraphQL will need updating.

module Gargantext.API.GraphQL.Utils where

import Control.Lens (view)
import Gargantext.API.Admin.Auth.Types (AuthenticatedUser (..), auth_node_id)
import Gargantext.Core.Config (HasJWTSettings(..))
import Gargantext.Database.Admin.Types.Node (NodeId)
import Gargantext.Database.Prelude (Cmd)
import Gargantext.Prelude
import Servant.Auth.Server (verifyJWT, JWTSettings)

data AuthStatus = Valid | Invalid

authUser :: (HasJWTSettings env) => NodeId -> Text -> Cmd env err AuthStatus
authUser ui_id token = do
  let token' = encodeUtf8 token
  jwtS <- view jwtSettings
  u <- liftBase $ getUserFromToken jwtS token'
  case u of
    Nothing -> pure Invalid
    Just au ->
      if au ^. auth_node_id == ui_id
        then pure Valid
        else pure Invalid

getUserFromToken :: JWTSettings -> ByteString -> IO (Maybe AuthenticatedUser)
getUserFromToken = verifyJWT
