# https://nixos.wiki/wiki/Java

{ fetchzip,
  makeWrapper,
  stdenv,
  writeShellScript,
  jre,

  version ? "4.5.9",
  hash ? "sha256-DOGBkGJfvR1PoXz2CNoo58HXwGLxvPKMChRqlrFtQLQ=", 
}:

stdenv.mkDerivation (finalAttrs:
  let
    startServer = writeShellScript "startCoreNLPServer.sh" ''
      set -x
      PORT=9000
  
      while getopts ':p:h' opt; do
        case $opt in
          (p) PORT=$OPTARG;;
          (h) echo "$(basename $0) [-p 9000]"
              exit 0
              ;;
        esac
      done
  
      shift "$((OPTIND - 1))"

      ${jre}/bin/java -mx4g -cp "$CORENLP_PATH/*" edu.stanford.nlp.pipeline.StanfordCoreNLPServer -port $PORT -timeout 15000 "$@"
    '';
    # see https://huggingface.co/stanfordnlp/CoreNLP/commits/main
    versionCommits = {
      "4.5.8" = "34264e88b7add9e0045f4727bc7d1872385f06aa";
      "4.5.9" = "06f79ee8b1ec475d7630b1871bfd75a57c77ffa4";
    };
    commit = versionCommits."${finalAttrs.version}";
  in

  {
    name = "corenlp";
    inherit version;
    src = fetchzip {
      inherit hash;
      # url = "http://nlp.stanford.edu/software/stanford-corenlp-${finalAttrs.version}.zip";
      # huggin face is more stable
      url = "https://huggingface.co/stanfordnlp/CoreNLP/resolve/${commit}/stanford-corenlp-latest.zip";
    };
    buildInputs = [
      jre
    ];
    nativeBuildInputs = [
      makeWrapper
    ];
    phases = [ "unpackPhase" "installPhase" ];
    installPhase = ''
      runHook preInstall
      mkdir -p $out/bin
      mkdir -p $out/share/corenlp
      cp -r . $out/share/corenlp
      makeWrapper ${startServer} $out/bin/startCoreNLPServer.sh \
        --set CORENLP_PATH "$out/share/corenlp"
      runHook postInstall
    '';
  }
)
