
module Gargantext.API.Node.Share.Types where

import Data.Aeson
import Data.Swagger (ToSchema)
import Gargantext.Database.Admin.Types.Node (NodeId)
import Gargantext.Prelude
import Gargantext.Utils.Aeson qualified as GUA


data ShareNodeParams = ShareTeamParams   { username :: Text  }
                     | SharePublicParams { node_id  :: NodeId }
  deriving (Generic)

-- TODO unPrefix "pn_" FromJSON, ToJSON, ToSchema, adapt frontend.
instance FromJSON  ShareNodeParams where
  parseJSON = genericParseJSON (defaultOptions { sumEncoding = GUA.defaultTaggedObject })
instance ToJSON    ShareNodeParams where
  toJSON = genericToJSON (defaultOptions { sumEncoding = GUA.defaultTaggedObject })
instance ToSchema  ShareNodeParams
