{-|
Module      : Gargantext.Database.Schema.NodeNode
Description :
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

Here is a longer description of this module, containing some
commentary with @some markup@.
-}

{-# LANGUAGE Arrows                 #-}
{-# LANGUAGE FunctionalDependencies #-}
{-# LANGUAGE LambdaCase             #-}
{-# LANGUAGE QuasiQuotes            #-}
{-# LANGUAGE TemplateHaskell        #-}

module Gargantext.Database.Schema.NodeNode (
  -- * Opaque type synonims
    NodeNodeRead
  , NodeNodeWrite
  , NodeNode

  -- * Types
  , NodeNodePoly(..)
  , NodeNodeCategory(..)
  , NodePublishPolicy(..)

  -- * Lenses
  , nn_node1_id
  , nn_node2_id
  , nn_score
  , nn_category

  -- * Prisms
  , _NNC_publish

  , nodeNodeTable
  ) where

import Control.Lens.TH
import Gargantext.Core (HasDBid(..))
import Gargantext.Core.Types
import Gargantext.Database.Schema.Prelude
import Gargantext.Prelude


data NodeNodePoly node1_id node2_id score cat
                   = NodeNode { _nn_node1_id   :: !node1_id
                              , _nn_node2_id   :: !node2_id
                              , _nn_score      :: !score
                              , _nn_category   :: !cat
                              } deriving (Show)

type NodeNodeWrite     = NodeNodePoly (Field SqlInt4)
                                      (Field SqlInt4)
                                      (Maybe  (Field SqlFloat8))
                                      (Maybe  (Field SqlInt4))

type NodeNodeRead      = NodeNodePoly (Field SqlInt4)
                                      (Field SqlInt4)
                                      (Field SqlFloat8)
                                      (Field SqlInt4)

data NodeNodeCategory
  = -- | Read-only/publishing relationship between nodes.
    NNC_publish !NodePublishPolicy
    deriving (Show, Eq, Ord)

instance HasDBid NodeNodeCategory where
  toDBid = \case
    NNC_publish roCats -> toDBid roCats
  lookupDBid x =
    NNC_publish <$> lookupDBid x

instance DefaultFromField SqlInt4 (Maybe NodeNodeCategory) where
    defaultFromField = (lookupDBid =<<) <$> fromPGSFromField

type NodeNode = NodeNodePoly NodeId NodeId (Maybe Double) (Maybe NodeNodeCategory)

$(makeAdaptorAndInstance "pNodeNode" ''NodeNodePoly)
makeLenses ''NodeNodePoly
makePrisms ''NodeNodeCategory

nodeNodeTable :: Table NodeNodeWrite NodeNodeRead
nodeNodeTable  =
  Table "nodes_nodes"
         ( pNodeNode
           NodeNode { _nn_node1_id = requiredTableField "node1_id"
                    , _nn_node2_id = requiredTableField "node2_id"
                    , _nn_score    = optionalTableField "score"
                    , _nn_category = optionalTableField "category"
                    }
                )
