
module Gargantext.API.Node.Update.Types where

import Data.Aeson
import Data.Swagger ( ToSchema )
import Gargantext.Core.Methods.Similarities (GraphMetric(..))
import Gargantext.Core.Text.Ngrams (NgramsType)
import Gargantext.Core.Viz.Graph.Types (BridgenessMethod, Strength)
import Gargantext.Core.Viz.Phylo (PhyloSubConfigAPI(..))
import Gargantext.Database.Admin.Types.Node ( NodeId, NodeType )
import Gargantext.Prelude
import Gargantext.Utils.Aeson qualified as GUA

------------------------------------------------------------------------
data UpdateNodeParams = UpdateNodeParamsList  { methodList  :: !Method      }

                      | UpdateNodeParamsGraph { methodGraph :: !UpdateNodeConfigGraph }

                      | UpdateNodeParamsTexts { methodTexts :: !Granularity }

                      | UpdateNodeParamsCorpus { methodGraph :: !UpdateNodeConfigGraph
                                               , methodPhylo :: !PhyloSubConfigAPI
                                               , methodTexts :: !Granularity
                                               , methodList  :: !Method }

                      | UpdateNodeParamsBoard { methodBoard :: !Charts      }

                      | LinkNodeReq           { nodeType    :: !NodeType
                                              , id          :: !NodeId }

                      | UpdateNodePhylo       { config :: !PhyloSubConfigAPI }
    deriving (Generic, Show, Eq)

----------------------------------------------------------------------
data Method = Basic | Advanced | WithModel
    deriving (Generic, Eq, Ord, Enum, Bounded, Show)

----------------------------------------------------------------------
data Granularity = NewNgrams | NewTexts | Both
    deriving (Generic, Eq, Ord, Enum, Bounded, Show)

----------------------------------------------------------------------
data Charts = Sources | Authors | Institutes | Ngrams | All
    deriving (Generic, Eq, Ord, Enum, Bounded, Show)

------------------------------------------------------------------------
data UpdateNodeConfigGraph = UpdateNodeConfigGraph { methodGraphMetric        :: !GraphMetric
                                                   , methodGraphBridgeness    :: !BridgenessMethod
                                                   , methodGraphEdgesStrength :: !Strength
                                                   , methodGraphNodeType1     :: !NgramsType
                                                   , methodGraphNodeType2     :: !NgramsType
                                                   }
    deriving (Generic, Show, Eq)

------------------------------------------------------------------------
-- TODO unPrefix "pn_" FromJSON, ToJSON, ToSchema, adapt frontend.
instance FromJSON  UpdateNodeParams where
  parseJSON = genericParseJSON (defaultOptions { sumEncoding = GUA.defaultTaggedObject })

instance ToJSON    UpdateNodeParams where
  toJSON = genericToJSON (defaultOptions { sumEncoding = GUA.defaultTaggedObject })

instance ToSchema  UpdateNodeParams

instance FromJSON  Method
instance ToJSON    Method
instance ToSchema  Method

instance FromJSON  Granularity
instance ToJSON    Granularity
instance ToSchema  Granularity

instance FromJSON  Charts
instance ToJSON    Charts
instance ToSchema  Charts

instance FromJSON UpdateNodeConfigGraph
instance ToJSON UpdateNodeConfigGraph
instance ToSchema UpdateNodeConfigGraph

------------------------------------------------------------------------


