{-# LANGUAGE BangPatterns        #-}
{-# LANGUAGE QuasiQuotes         #-}
{-# LANGUAGE ScopedTypeVariables #-}
{-# LANGUAGE TypeApplications    #-}
{-# LANGUAGE TypeFamilies        #-}

module Test.API.Private.List (
    tests
  ) where

import Data.Aeson.QQ
import Data.Text.IO qualified as TIO
import Gargantext.API.Ngrams.List.Types
import Gargantext.API.Ngrams.Types qualified as APINgrams
import Gargantext.API.Node.Corpus.New.Types qualified as FType
import Gargantext.Core.Config
import Gargantext.Core.Types
import Gargantext.Core.Types.Individu
import Gargantext.Prelude
import Paths_gargantext
import Servant.Client.Streaming
import Test.API.Prelude (newCorpusForUser, checkEither)
import Test.API.Routes
import Test.API.Setup
import Test.Database.Types
import Test.Hspec (Spec, it, aroundAll, describe, sequential)
import Test.Hspec.Expectations
import Test.Hspec.Wai.Internal (withApplication)
import Test.Utils
import Fmt

tests :: Spec
tests = sequential $ aroundAll withTestDBAndPort $ do
  describe "Prelude" $ do
    it "setup DB triggers" $ \SpecContext{..} -> do
      setupEnvironment _sctx_env
      -- Let's create the Alice user.
      void $ createAliceAndBob _sctx_env

    describe "Importing terms as TSV" $ do

      it "[#381] should work (and return a non-empty list of ngrams" $ \(SpecContext testEnv port app _) -> do
        cId <- newCorpusForUser testEnv "alice"
        let log_cfg = (test_config testEnv) ^. gc_logging
        withApplication app $ do
          withValidLogin port "alice" (GargPassword "alice") $ \clientEnv token -> do
            ([listId] :: [NodeId]) <- protectedJSON token "POST" (mkUrl port ("/node/" <> build cId)) [aesonQQ|{"pn_typename":"NodeList","pn_name":"Testing"}|]
            -- Upload the CSV doc
            simpleNgrams <- liftIO (TIO.readFile =<< getDataFileName "test-data/issue-381/Termes_A_Ajouter_T4SC_Intellixir.tsv")
            let params = WithTextFile { _wtf_filetype = FType.TSV
                                      , _wtf_data = simpleNgrams
                                      , _wtf_name = "simple.tsv" }
            ji <- checkEither $ liftIO $ runClientM (add_tsv_to_list token listId params) clientEnv
            _ <- pollUntilWorkFinished log_cfg port ji

            -- Now check that we can retrieve the ngrams, and the ngrams list is not empty!
            liftIO $ do
              eRes <- checkEither $ runClientM (get_table_ngrams token cId APINgrams.Terms listId 50 Nothing (Just MapTerm) Nothing Nothing Nothing Nothing) clientEnv
              let (APINgrams.NgramsTable terms) = APINgrams._vc_data eRes
              length terms `shouldSatisfy` (>= 1)
