{-# LANGUAGE TypeOperators #-}
{-# LANGUAGE DeriveGeneric #-}

module Gargantext.API.Routes.Named.Share (
  -- * Routes types
    ShareNode(..)
  , Unpublish(..)
  , ShareURL(..)

  -- * API types (which appears in the routes)
  , ShareNodeParams(..)
  ) where

import Data.Text (Text)
import GHC.Generics
import Gargantext.API.Node.Share.Types ( ShareNodeParams (..) )
import Gargantext.Database.Admin.Types.Node
import Prelude
import Servant


newtype ShareURL mode = ShareURL
  { shareUrlEp :: mode :- Summary "Fetch URL for sharing a node"
                       :> QueryParam "type" NodeType
                       :> QueryParam "id" NodeId
                       :> Get '[JSON] Text
  } deriving Generic


newtype ShareNode mode = ShareNode
  { shareNodeEp :: mode :- Summary " Share Node with username"
                        :> ReqBody '[JSON] ShareNodeParams
                        :> Post    '[JSON] Int
  } deriving Generic


newtype Unpublish mode = Unpublish
  { unpublishEp :: mode :- Summary " Unpublish Node" :> Capture "node_id" NodeId :> Put '[JSON] Int
  } deriving Generic
