
module Test.API where

import Gargantext.Core.Config.Types (NotificationsConfig)
import Prelude
import Test.Hspec
import qualified Test.API.Authentication as Auth
import qualified Test.API.Errors as Errors
import qualified Test.API.GraphQL as GraphQL
import qualified Test.API.Notifications as Notifications
import qualified Test.API.Private as Private
import qualified Test.API.UpdateList as UpdateList

tests :: NotificationsConfig -> Spec
tests _nc = describe "API" $ do
  Auth.tests
  Private.tests
  GraphQL.tests
  Errors.tests
  UpdateList.tests
  -- | TODO This would work if I managed to get forking dispatcher &
  --   exchange listeners properly
  -- Notifications.tests nc
