
module CLI.Types where

import Prelude
import Data.String
import Data.Text (Text)

newtype CorpusFile = CorpusFile { _CorpusFile :: FilePath }
  deriving (Show, Eq, IsString)

newtype TermListFile = TermListFile { _TermsListFile :: FilePath }
  deriving (Show, Eq, IsString)

newtype OutputFile = OutputFile { _OutputFile :: FilePath }
  deriving (Show, Eq, IsString)

data ObfuscateDBArgs = ObfuscateDBArgs {
    dbHost     :: !Text
  , dbPort     :: !Int
  , dbName     :: !Text
  , dbUser     :: !Text
  , dbPassword :: !Text
  } deriving (Show, Eq)

data AdminArgs = AdminArgs
  { iniPath :: !FilePath
  , emails  :: [String]
  } deriving (Show, Eq)

data CLICmd
  = CCMD_clean_csv_corpus
  | CCMD_filter_terms_and_cooc !CorpusFile !TermListFile !OutputFile
  | CCMD_obfuscate_db !ObfuscateDBArgs
  | CCMD_admin !AdminArgs
  deriving (Show, Eq)

data CLI =
  CLISub CLICmd
  deriving (Show, Eq)


