{-# LANGUAGE DeriveGeneric #-}
{-# LANGUAGE TypeOperators #-}
module Gargantext.API.Routes.Named.File (
  -- * Routes types
    FileAPI(..)
  , FileAsyncAPI(..)
  ) where

import Data.Text (Text)
import GHC.Generics
import Gargantext.API.Admin.Orchestrator.Types
import Gargantext.API.Node.Types
import Servant
import Gargantext.API.Node.File.Types

data FileAPI mode = FileAPI
  { fileDownloadEp :: mode :- Summary "File download"
                           :> "download"
                           :> Get '[RESPONSE] (Headers '[Servant.Header "Content-Type" Text] BSResponse)
  } deriving Generic


data FileAsyncAPI mode = FileAsyncAPI
  { addFileAsyncEp :: mode :- Summary "File Async Api"
                           :> "file"
                           :> "add"
                           :> NamedRoutes (AsyncJobs JobLog '[FormUrlEncoded] NewWithFile JobLog)
  } deriving Generic

