{-# LANGUAGE TypeOperators #-}

module Gargantext.API.Routes.Named.Publish (
    PublishRequest(..)
  , PublishAPI(..)
  ) where

import Data.Aeson as JS
import Data.Swagger
import Gargantext.Database.Query.Table.NodeNode (NodePublishPolicy)
import GHC.Generics (Generic)
import Prelude
import Servant
import Test.QuickCheck

newtype PublishRequest = PublishRequest
  { pubrq_policy :: NodePublishPolicy
  } deriving (Show, Eq, Generic)

instance ToSchema PublishRequest

instance ToJSON PublishRequest where
  toJSON (PublishRequest pol) =
    JS.object [ "policy" JS..= toJSON pol ]

instance FromJSON PublishRequest where
  parseJSON = withObject "PublishRequest" $ \o -> do
    pubrq_policy <- o JS..: "policy"
    pure $ PublishRequest{..}

instance Arbitrary PublishRequest where
  arbitrary = PublishRequest <$> arbitraryBoundedEnum

newtype PublishAPI mode = PublishAPI
  { publishEp :: mode :- Summary "Publish a Corpus Node"
                      :> ReqBody '[JSON] PublishRequest
                      :> Delete '[JSON] Int
  } deriving Generic
