{-|
Module      : Main.hs
Description : Gargantext starter
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

Main specifications to index a corpus with a term list

 -}

{-# LANGUAGE Strict             #-}
{-# LANGUAGE LambdaCase #-}
{-# LANGUAGE TypeApplications #-}

module Main where

import Prelude

import CLI.FilterTermsAndCooc
import CLI.ObfuscateDB (obfuscateDB, obfuscateDBCmd)
import CLI.Types
import Options.Applicative
import CLI.Admin (adminCLI, adminCmd)
import CLI.FileDiff (fileDiffCLI, fileDiffCmd)
import CLI.Import (importCLI, importCmd)
import CLI.Ini (iniCLI, iniCmd)
import CLI.Init (initCLI, initCmd)
import CLI.Invitations (invitationsCLI, invitationsCmd)
import CLI.Phylo (phyloCLI, phyloCmd)
import CLI.Phylo.Profile (phyloProfileCLI, phyloProfileCmd)
import CLI.Server.Routes (routesCLI, routesCmd)
import CLI.Upgrade (upgradeCLI, upgradeCmd)
import CLI.Worker (workerCLI, workerCmd)

runCLI :: CLI -> IO ()
runCLI = \case
  CLISub CCMD_clean_csv_corpus
    -> putStrLn "TODO."
  CLISub (CCMD_filter_terms_and_cooc corpusFile termListFile outputFile)
    -> filterTermsAndCoocCLI corpusFile termListFile outputFile
  CLISub (CCMD_obfuscate_db args)
    -> obfuscateDB args
  CLISub (CCMD_admin args)
    -> adminCLI args
  CLISub (CCMD_import args)
    -> importCLI args
  CLISub (CCMD_ini args)
    -> iniCLI args
  CLISub (CCMD_init args)
    -> initCLI args
  CLISub (CCMD_invitations args)
    -> invitationsCLI args
  CLISub (CCMD_phylo args)
    -> phyloCLI args
  CLISub CCMD_phylo_profile
    -> phyloProfileCLI
  CLISub (CCMD_upgrade args)
    -> upgradeCLI args
  CLISub (CCMD_golden_file_diff args)
    -> fileDiffCLI args
  CLISub (CCMD_routes args)
    -> routesCLI args
  CLISub (CCMD_worker args)
    -> workerCLI args


main :: IO ()
main = runCLI =<< execParser opts
  where
    opts = info (helper <*> allOptions)
      ( fullDesc
     <> progDesc "CLI for the gargantext-server. Type --help for all the commands."
     <> header "gargantext-cli tools" )

allOptions :: Parser CLI
allOptions = subparser (
                 filterTermsAndCoocCmd <>
                 obfuscateDBCmd <>
                 adminCmd <>
                 importCmd <>
                 iniCmd <>
                 initCmd <>
                 invitationsCmd <>
                 phyloCmd <>
                 phyloProfileCmd <>
                 upgradeCmd <>
                 fileDiffCmd <>
                 routesCmd <>
                 workerCmd
                 )
