{-|
Module      : Gargantext.API.Context
Description : Server API
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

{-# LANGUAGE ScopedTypeVariables  #-}
{-# LANGUAGE TemplateHaskell      #-}
{-# LANGUAGE TypeOperators        #-}

module Gargantext.API.Context
  where

import Gargantext.API.Admin.Auth (withNamedAccess)
import Gargantext.API.Admin.Auth.Types (PathId(..), AuthenticatedUser)
import Gargantext.API.Prelude (IsGargServer)
import Gargantext.API.Routes.Named.Context qualified as Named
import Gargantext.Database.Admin.Types.Node (ContextId, contextId2NodeId)
import Gargantext.Database.Prelude
import Gargantext.Database.Query.Table.Context (getContextWith)
import Gargantext.Prelude
import Servant.Server.Generic (AsServerT)

-------------------------------------------------------------------
-- TODO use Context instead of Node
-- TODO NodeAPI -> ContextAPI
contextAPI :: ( IsGargServer env err m
              , JSONB a
              , FromJSON a
              , ToJSON a )
           => Proxy a
           -> AuthenticatedUser
           -> ContextId
           -> Named.ContextAPI a (AsServerT m)
contextAPI p uId id' =
  withNamedAccess uId (PathNode $ contextId2NodeId id') contextAPI'
  where
    contextAPI' = Named.ContextAPI $ runDBQuery (getContextWith   id' p)
