{-# LANGUAGE QuasiQuotes #-}

{-
Database.PGMQ.Simple functions tests.
-}


module Main
where

import Database.PostgreSQL.Simple qualified as PSQL
import Database.PGMQ.Simple qualified as PGMQ
import Database.PGMQ.Types qualified as PGMQ


main :: IO ()
main = do
  let connInfo = PSQL.defaultConnectInfo { PSQL.connectUser = "postgres"
                                         , PSQL.connectDatabase = "postgres" }
  conn <- PSQL.connect connInfo

  PGMQ.initialize conn

  PGMQ.dropQueue conn "test"
  _metrics <- PGMQ.getMetrics conn "test"

  let queue = "test"
  PGMQ.createQueue conn "test"
  PGMQ.sendMessage conn queue ("test message 1" :: String) 0
  PGMQ.sendMessage conn queue ("test message 2" :: String) 0

  allMetrics <- PGMQ.getMetricsAll conn
  putStrLn $ "allMetrics: " <> show allMetrics

  testMetrics <- PGMQ.getMetrics conn queue
  putStrLn $ "testMetrics: " <> show testMetrics

  
  mMsg1 <- (PGMQ.readMessage conn queue 10 :: IO (Maybe (PGMQ.Message String)))
  case mMsg1 of
    Nothing -> undefined
    Just msg -> do
      putStrLn $ "message 1: " <> PGMQ.message msg
    
      PGMQ.archiveMessage conn queue (PGMQ.msgId msg)


  mMsg2 <- (PGMQ.readMessage conn queue 10 :: IO (Maybe (PGMQ.Message String)))
  case mMsg2 of
    Nothing -> undefined
    Just msg -> do
      putStrLn $ "message 2: " <> PGMQ.message msg
    
      PGMQ.deleteMessage conn queue (PGMQ.msgId msg)

    
  PGMQ.sendMessages conn queue (["test message 3", "test message 4"] :: [String]) 0

  messagesA <- (PGMQ.readMessages conn queue 10 2 :: IO [PGMQ.Message String])
  PGMQ.archiveMessages conn queue [PGMQ.msgId msg | msg <- messagesA]


  PGMQ.sendMessages conn queue (["test message 5", "test message 6"] :: [String]) 0

  messagesD <- (PGMQ.readMessages conn queue 10 2 :: IO [PGMQ.Message String])
  PGMQ.deleteMessages conn queue [PGMQ.msgId msg | msg <- messagesD]

  queues <- PGMQ.listQueues conn
  putStrLn $ "queues: " <> show queues
    

  PGMQ.sendMessage conn queue ("test message 7" :: String) 0
  mMsgP <- (PGMQ.popMessage conn queue :: IO (Maybe (PGMQ.Message String)))
  case mMsgP of
    Nothing -> undefined
    Just msg -> do
      putStrLn $ "message pop: " <> PGMQ.message msg
      PGMQ.setMessageVt conn queue (PGMQ.msgId msg) 10

  PGMQ.sendMessage conn queue ("test message 8" :: String) 0
  metrics <- PGMQ.getMetrics conn queue
  putStrLn $ "before purge: " <> show metrics
  PGMQ.purgeQueue conn queue
  metrics2 <- PGMQ.getMetrics conn queue
  putStrLn $ "after purge: " <> show metrics2
   
  PGMQ.dropQueue conn queue
    
  return ()
