{-# LANGUAGE QuasiQuotes #-}

{-
Testing exception catch for PSQL.
-}


module Main
where

import Control.Exception (SomeException(..), catch)
import Control.Monad (void)
import Database.PostgreSQL.Simple qualified as PSQL
import Database.PostgreSQL.Simple.SqlQQ (sql)


main :: IO ()
main = do
  let connInfo = PSQL.defaultConnectInfo { PSQL.connectUser = "postgres"
                                         , PSQL.connectDatabase = "postgres" }
  conn <- PSQL.connect connInfo

  void (PSQL.execute_ conn [sql| CREATE EXTENSION IF NOT EXISTS pgmq |])

  let queue = "test" :: String
  -- catch exception of deleting a queue that doesn't exist
  catch (
      void (PSQL.query conn [sql| SELECT pgmq.drop_queue(?) |] (PSQL.Only queue) :: IO [PSQL.Only Bool])
    ) (\e@(SomeException _) -> putStrLn $ "err: " <> show e)

  return ()
