module Main where

import Test.Integration.Broker (brokerTests, pgmqBrokerInitParams)
import Test.Integration.PGMQ.Simple (pgmqSimpleTests)
import Test.Integration.Worker (workerTests, pgmqWorkerBrokerInitParams)
import Test.Tasty
import Test.Tasty.Hspec



main :: IO ()
main = do
  pgmqBInitParams <- pgmqBrokerInitParams
  brokerSpec <- testSpec "brokerTests" (brokerTests pgmqBInitParams)
  pgmqWBInitParams <- pgmqWorkerBrokerInitParams
  workerSpec <- testSpec "workerTests" (workerTests pgmqWBInitParams)
  pgmqSimpleSpec <- testSpec "pgmqSimpleTests" pgmqSimpleTests

  defaultMain $ testGroup "integration tests"
    [ brokerSpec
    , pgmqSimpleSpec
    , workerSpec ]


