'use strict';

import { useEffect, useState } from 'react';
import Cookies from 'js-cookie';

export const _useFeatureFlag = function useFeatureFlag(cookieKeys) {
  const checkFeatureFlag = () =>
    cookieKeys.some((key) => Cookies.get(key) === 'true');

  const [isFeatureEnabled, setIsFeatureEnabled] = useState(checkFeatureFlag);

  
  useEffect(() => {
    const hasEnabledFlag = checkFeatureFlag();
    isFeatureEnabled && console.error("Warning: feature flags are in use");

    if (isFeatureEnabled !== hasEnabledFlag) {
      setIsFeatureEnabled(hasEnabledFlag);
    }
  }, [cookieKeys, isFeatureEnabled]);

  return isFeatureEnabled;
};


