{-|
Module      : Main.hs
Description : Gargantext Admin tools
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX



 -}

{-# LANGUAGE Strict            #-}

module Main where

import Gargantext.API.Dev (withDevEnv, runCmdDev)
import Gargantext.API.Prelude (GargError)
import Gargantext.Database.Action.User.New (newUsers)
import Gargantext.Database.Admin.Types.Node
import Gargantext.Database.Prelude (Cmd'')
import Gargantext.Prelude
import System.Environment (getArgs)
import Gargantext.API.Admin.EnvTypes (DevEnv)

main :: IO ()
main = do
  (iniPath:mails) <- getArgs

  withDevEnv iniPath $ \env -> do
    x <- runCmdDev env ((newUsers $ map cs mails) :: Cmd'' DevEnv GargError [UserId])
    putStrLn (show x :: Text)
  pure ()
