
module Gargantext.API.Server.Named.Private where

import Gargantext.API.Admin.Auth.Types (AuthenticatedUser(..))
import Gargantext.API.Admin.EnvTypes (Env)
import Gargantext.API.Context
import Gargantext.API.Count qualified as Count
import Gargantext.API.Errors.Types
import Gargantext.API.Members (members)
import Gargantext.API.Ngrams.List qualified as List
import Gargantext.API.Node
import Gargantext.API.Node qualified as Tree
import Gargantext.API.Node.Contact as Contact
import Gargantext.API.Node.Corpus.Export qualified as CorpusExport
import Gargantext.API.Node.Document.Export (documentExportAPI)
import Gargantext.API.Node.Phylo.Export qualified as PhyloExport
import Gargantext.API.Node.ShareURL ( shareURL )
import Gargantext.API.Prelude
import Gargantext.API.Routes (addCorpusWithForm, addCorpusWithQuery)
import Gargantext.API.Routes.Named.Private qualified as Named
import Gargantext.API.Server.Named.Ngrams
import Gargantext.API.Server.Named.Viz qualified as Viz
import Gargantext.Core.Types.Individu (User(..))
import Gargantext.Database.Admin.Types.Hyperdata
import Gargantext.Prelude
import Servant.Auth.Swagger ()
import Servant.Server.Generic (AsServerT)


---------------------------------------------------------------------
-- | Server declarations

-- TODO-SECURITY admin only: withAdmin
-- Question: How do we mark admins?
serverGargAdminAPI :: Named.GargAdminAPI (AsServerT (GargM Env BackendInternalError))
serverGargAdminAPI = Named.GargAdminAPI
  { rootsEp       = roots
  , adminNodesAPI = nodesAPI
  }


serverPrivateGargAPI'
  :: AuthenticatedUser -> Named.GargPrivateAPI' (AsServerT (GargM Env BackendInternalError))
serverPrivateGargAPI' authenticatedUser@(AuthenticatedUser userNodeId userId)
       =  Named.GargPrivateAPI'
       { gargAdminAPI      = serverGargAdminAPI
       , nodeEp            = nodeAPI authenticatedUser
       , contextEp         = contextAPI (Proxy :: Proxy HyperdataAny) authenticatedUser
       , corpusNodeAPI     = corpusNodeAPI authenticatedUser
       , corpusNodeNodeAPI = nodeNodeAPI (Proxy :: Proxy HyperdataAny) authenticatedUser
       , corpusExportAPI   = CorpusExport.getCorpus
       , annuaireEp        = annuaireNodeAPI authenticatedUser
       , contactAPI        = contactAPI authenticatedUser
       , tableNgramsAPI    = apiNgramsTableDoc authenticatedUser
       , phyloExportAPI    = PhyloExport.api userNodeId
       , documentExportAPI = documentExportAPI userNodeId
       , countAPI          = Count.countAPI
       , graphAPI          = Viz.graphAPI authenticatedUser userId
       , treeAPI           = Tree.treeAPI authenticatedUser
       , treeFlatAPI       = Tree.treeFlatAPI authenticatedUser
       , membersAPI        = members
       , addWithFormEp     = addCorpusWithForm (RootId userNodeId)
       , addWithQueryEp    = addCorpusWithQuery (RootId userNodeId)
       , listGetAPI        = List.getAPI
       , listJsonAPI       = List.jsonAPI
       , listTsvAPI        = List.tsvAPI
       , shareUrlEp        = shareURL
       }
