const { createProxyMiddleware } = require("http-proxy-middleware");


module.exports = function (app) {
  app.use("/api/v1.0/auth", createProxyMiddleware({
    target: 'http://127.0.0.1:8008/api/v1.0/auth',
    changeOrigin: true,
  }))
  // app.use("/api", createProxyMiddleware({
  //   target: 'http://127.0.0.1:8008/api',
  //   changeOrigin: true,
  // }))
  app.use(
    "/ws",
    createProxyMiddleware({
      target: "ws://127.0.0.1:8008",
      ws: true,
      changeOrigin: true,
      logger: console,
      on: {
        proxyRes: (proxyRes, req, res) => {
          console.log(`[Proxy Response] ${req.method} ${req.url} <- ${proxyRes.statusCode}`);
        },
        proxyReqWs: (proxyReq, req, socket, options, head) => {
          console.log(`WS RESPONSE, ${req.method} ${req.url} <- ${proxyReq.getHeader("host")}`);
          proxyReq.setHeader("origin", "http://localhost:8008");
        },
        proxyReq: (proxyReq, req, res) => {
          console.log(`[Proxy Req] ${req.method} ${req.url} <- ${proxyReq.getHeader("host")}`);
          proxyReq.setHeader("origin", "http://localhost:8008");
        },
        error: (err, req, res) => {
            console.error(`[Proxy Error] ${req.method} ${req.url} - ${err.message}`);
            res.writeHead(500, { "Content-Type": "text/plain" });
            res.end("Proxy error occurred.");
        }
      }
    })
  );
};




