'use strict';

import dayjs from '../../src/external-deps/dayjs.min.js';

/**
 * @name yearToDate
 * @param {string} year
 * @returns {Date}
 */
export function yearToDate(year) {
  var d = new Date();

  d.setYear(parseInt(year));
  d.setMonth(0);
  d.setDate(1);

  return d;
}
/**
 * @name monthToDate
 * @param {string} year
 * @returns {Date}
 */
export function monthToDate(month) {
  var d = dayjs('0001-01-01T00:00:00Z');

  return d.add(month, 'months').toDate();
}
/**
 * @name weekToDate
 * @param {string} year
 * @returns {Date}
 */
export function weekToDate(week) {
  // week is number of days divided by 7
  var d = dayjs('0001-01-01T00:00:00Z');

  return d.add(week*7, 'days').toDate();
}
/**
 * @name dayToDate
 * @param {string} year
 * @returns {Date}
 */
export function dayToDate(days) {
  var d = dayjs('0001-01-01T00:00:00Z');

  return d.add(days, 'days').toDate();
}
/**
 * @name hourToDate
 * @param {string} year
 * @returns {Date}
 */
export function hourToDate(hours) {
  var d = dayjs('0001-01-01T00:00:00Z');

  return d.add(hours, 'hours').toDate();
}
/**
 * @name minuteToDate
 * @param {string} year
 * @returns {Date}
 */
export function minuteToDate(minutes) {
  var d = dayjs('0001-01-01T00:00:00Z');

  return d.add(minutes, 'minutes').toDate();
}
/**
 * @name secondToDate
 * @param {string} year
 * @returns {Date}
 */
export function secondToDate(seconds) {
  var d = dayjs('0001-01-01T00:00:00Z');

  return d.add(seconds, 'seconds').toDate();
}
/**
 * @name stringToDate
 * @param {string} str
 * @returns {Date}
 */
export function stringToDate(str) {
  var arr = (str.replace('"','')).split('-');
  var d = new Date();

  d.setYear(parseInt(arr[0]));
  d.setMonth(parseInt(arr[1]));
  d.setMonth(d.getMonth() - 1);
  d.setDate(parseInt(arr[2]));

  return d;
}
/**
 * @name utcStringToDate
 * @param {string} str
 * @returns {Date}
 */
export function utcStringToDate(str) {
  var arr = ((str.replace('"','')).replace(' UTC','')).split(/[\s-:]+/);
  var d = new Date();

  d.setYear(parseInt(arr[0]));
  d.setMonth(parseInt(arr[1]));
  d.setDate(parseInt(arr[2]));
  d.setHours(parseInt(arr[3]), parseInt(arr[4]), parseInt(arr[5]))

  return d;
}
